# Ski Rental

## Files
- **`Ski_rental.py`**  
  Main program implementing algorithms and experiments for the ski rental problem.  
  Includes baselines (`A_b`, `A_b(r-1)`, `A_b/(r-1)`, `A_mid`), robust algorithms (**MAX**, **AVG**, **CVaR**), and additional experiments.

## Functionality

1. **Cost Functions**  
   - `cost_alg(x, λ, b)`: Cost of the algorithm with threshold λ.  
   - `optimal_cost(x, b)`: Offline optimal cost.

2. **Weight Functions**  
   - `linear_weight(x, y, h1, h2)`: Linear (triangular) weighting.  
   - `gaussian_weight(x, y, h1, h2)`: Gaussian weighting truncated to `[y-h1, y+h2]`.

3. **Distributions**  
   - `linear_mu(...)`, `gaussian_mu(...)`, `uniform_mu(...)`: Priors used for CVaR and expected costs.

4. **Metrics**  
   - Performance ratio vs OPT.  
   - Expected cost under μ.  
   - Improvement vs baselines.

5. **Optimization**  
   - `find_best_lambda_discrete(...)`: Finds the best λ under **MAX**, **AVG**, or **CVaR**.

6. **Experiments**  
   - `ski_rental_experiment(...)`: Main simulation with average ratios, expected costs, and improvements.  
   - `ski_rental_gaussian_global_weighted_avg_experiment(...)`: Gaussian-weighted evaluation.  
   - `plot_all_strategies_comparison(...)`: Side-by-side strategy comparison.  
   - `experiment_fixed_interval_shifting_y(...)`: Varies y inside fixed intervals.  
   - `experiment_varying_alpha_for_cvar(...)`: CVaR sensitivity to α.

7. **Visualization**  
   - Plots mean performance ratios ± 95% CI for all algorithms and baselines.  
   - Exports figures as `.pdf` and `.png`.

## Usage

- **PyCharm / Direct run**:  
  ```bash
  python Ski_rental.py
  
  ### License
This project is under the [MIT License](https://opensource.org/licenses/MIT).

